<?php
$char_name = trim($_POST['char_name'] ?? '');
$image_data = $_POST['image_data'] ?? '';

if (!$char_name || !$image_data) {
    http_response_code(400);
    exit("Missing data");
}

$dir = __DIR__;
if (!is_dir($dir)) {
    mkdir($dir, 0755, true);
}

// 🖼️ Декодируем base64 и сохраняем файл
$img_data = base64_decode($image_data);
$filename = $char_name . "_" . date("Ymd_His") . ".png";
$filepath = $dir . "/" . $filename;
file_put_contents($filepath, $img_data);

// ✅ Удаляем строку из request.txt
$request_file = $dir . "/request.txt";
if (file_exists($request_file)) {
    $lines = file($request_file, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
    $filtered = array_filter($lines, function ($line) use ($char_name) {
        $entry = json_decode($line, true);
        return isset($entry['char_name']) && $entry['char_name'] !== $char_name;
    });
    file_put_contents($request_file, implode(PHP_EOL, $filtered) . PHP_EOL);
}

echo "Screenshot saved as $filename";
