<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");

if (!isset($_POST['hwid'])) {
    http_response_code(400);
    echo json_encode(["error" => "Missing HWID"]);
    exit;
}

$hwid = trim($_POST['hwid']);
$path = __DIR__ . '/blacklist.json';
$screenshotsDir = __DIR__ . '/AntiCheat/screenshots/';

if (!file_exists($path)) {
    http_response_code(500);
    echo json_encode(["error" => "Blacklist file not found"]);
    exit;
}

$data = json_decode(file_get_contents($path), true);

if (!isset($data[$hwid])) {
    http_response_code(404);
    echo json_encode(["error" => "HWID not found"]);
    exit;
}

// 🖼 Удаляем скриншот, если указан
if (!empty($data[$hwid]['screenshot_file'])) {
    $screenshotPath = $screenshotsDir . basename($data[$hwid]['screenshot_file']);
    if (file_exists($screenshotPath)) {
        unlink($screenshotPath);
    }
}

// ❌ Удаляем запись
unset($data[$hwid]);

// 💾 Сохраняем обновлённый JSON
if (file_put_contents($path, json_encode($data, JSON_PRETTY_PRINT))) {
    echo json_encode(["success" => true, "message" => "HWID and screenshot deleted"]);
} else {
    http_response_code(500);
    echo json_encode(["error" => "Failed to save file"]);
}
?>
